unit AviInfoTipImpl;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  ComObj, ActiveX, AviInfoTip_TLB, StdVcl, shlobj, windows, classes, sysutils, avidata;

type
  TAviInfoTip_ = class(TAutoObject, IAviInfoTip, IQueryInfo, IPersistFile, IPersist)
  protected
    pMalloc : IMalloc;
    FFile : string;
    {IQueryInfo}
    function GetInfoTip(dwFlags: DWORD; var ppwszTip: PWideChar): HResult; stdcall;
    function GetInfoFlags(out pdwFlags: DWORD): HResult; stdcall;
    {IPersistFile}
    function IsDirty: HResult; stdcall;
    function Load(pszFileName: POleStr; dwMode: Longint): HResult;stdcall;
    function Save(pszFileName: POleStr; fRemember: BOOL): HResult;stdcall;
    function SaveCompleted(pszFileName: POleStr): HResult;stdcall;
    function GetCurFile(out pszFileName: POleStr): HResult;stdcall;
    {IPersist} // need to implement, since IPersistFile is derived from IPersist
    function GetClassID(out classID: TCLSID): HResult; stdcall;
  public
    procedure Initialize; override;
    destructor Destroy; override;
  end;

  TAviInfoTipFactory = class(TAutoObjectFactory)
  protected
    procedure ApproveShellExtension(Register: Boolean; const ClsID: string);
    function GetProgID: string; override;
  public
    procedure UpdateRegistry(Register: Boolean); override;
  end;

implementation

uses ComServ, registry;

procedure TAviInfoTip_.Initialize;
begin
  inherited;
  if Failed(ShGetMalloc(pMalloc)) then
    pMalloc := nil;
end;

destructor TAviInfoTip_.Destroy;
begin
  inherited;
  pMalloc := nil;
end;

function TAviInfoTip_.GetInfoTip(dwFlags: DWORD; var ppwszTip: PWideChar): HResult;
var
  avi:TAVIData;
  szTip : string;
  i:integer;
  avistream:TAVIInfo;
begin
  Result := S_OK;
  try
    avi := TAVIData.Create;
    avi.process(FFile);
    for i:=0 to avi.streamlist.Count-1 do
    begin
      avistream:=TAVIInfo(avi.streamlist.items[i]);
      szTip:=szTip+avistream.info;
      if (i<>(avi.streamlist.Count-1)) then
        szTip:=szTip+#10+#13+#10+#13

    end;

  except
    on E:Exception do
    begin
      szTip:='Video File'+#10+#13+
               'Exception:'+E.Message;
    end
  end;
  ppwszTip := pMalloc.Alloc( sizeof(WideChar)*(Length(szTip)+1));
  if (ppwszTip <> nil) then
    ppwszTip := StringToWideChar(szTip, ppwszTip, sizeof(WideChar)*Length(szTip) +1 );
end;

function TAviInfoTip_.GetInfoFlags(out pdwFlags: DWORD): HResult; stdcall;
begin
  pdwFlags := 0;
  Result := E_NOTIMPL;
end;

function TAviInfoTip_.IsDirty: HResult;
begin
  Result := E_NOTIMPL;
end;

function TAviInfoTip_.Load(pszFileName: POleStr; dwMode: Integer): HResult;
begin
  FFile := pszFileName;
  Result := S_OK;
end;

function TAviInfoTip_.Save(pszFileName: POleStr; fRemember: BOOL): HResult;
begin
  Result := E_NOTIMPL;
end;

function TAviInfoTip_.SaveCompleted(pszFileName: POleStr): HResult;
begin
  Result := E_NOTIMPL;
end;

function TAviInfoTip_.GetCurFile(out pszFileName: POleStr): HResult;
begin
  Result := E_NOTIMPL;
end;

function TAviInfoTip_.GetClassID(out classID: TCLSID): HResult;
begin
  Result := E_NOTIMPL;
end;

{ TAviInfoTipFactory }

procedure TAviInfoTipFactory.ApproveShellExtension(Register: Boolean;
const ClsID: string);
// This registry entry is required in order for the extension to
// operate correctly under Windows NT.
const
  SApproveKey = 'SOFTWARE\Microsoft\Windows\CurrentVersion\Shell Extensions\Approved';
begin
  with TRegistry.Create do
  try
    RootKey := HKEY_LOCAL_MACHINE;
    if not OpenKey(SApproveKey, True) then Exit;
    if Register then WriteString(ClsID, Description)
    else DeleteValue(ClsID);
  finally
    Free;
  end;
end;

function TAviInfoTipFactory.GetProgID: string;
begin
// ProgID not needed for shell extension
Result := '';
end;

procedure TAviInfoTipFactory.UpdateRegistry(Register: Boolean);
var
  ClsID: String;
begin
  ClsID := GUIDToString(ClassID);
  inherited UpdateRegistry(Register);
  ApproveShellExtension(Register, ClsID);
  if Register then
    CreateRegKey('.avi\shellex\' + SID_IQueryInfo, '', ClsID)
  else
    DeleteRegKey('.avi\shellex\' + SID_IQueryInfo);
end;

initialization
  TAviInfoTipFactory.Create(ComServer, TAviInfoTip_, Class_AviInfoTip_,
    ciMultiInstance, tmApartment);
end.
